
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:44:42 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief this file containes needed worarounds for the cache code.
   *     
   *
   *  \version parser_wa.c#1:csrc:8
   *  \author mottig
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/************* Include Files ****************/ 

#include "DX_VOS_BaseTypes.h"
#include "dx_hw_defs.h"
#include "vos_op_code.h"


/************************ Defines ******************************/

/************************ Enums ******************************/

/************************ Typedefs ******************************/


/************************ Global Data ******************************/

/************* Private function prototype ****************/

/************************ Public Functions ******************************/


void *DX_VOS_MemSet6(void *dst, DxInt32 ch, DxUint32 nbytes)
{
    DxUint8* p = (DxUint8*)dst;
    while (nbytes > 0) 
	{
        nbytes--;
        *p++ = ch;
    }
    return dst;
}

void *DX_VOS_MemSetZero6(void *dst, DxUint32 nbytes)
{
    return DX_VOS_MemSet6(dst, 0x0, nbytes);
}

DxInt DX_VOS_MemCmp(const void* aTarget, const void* aSource, DxUint aSize)
{
    unsigned char *a = (unsigned char*)aTarget;
    unsigned char *b = (unsigned char*)aSource;
	int tmp;

	while (aSize--)
	{
	  if (tmp = *a++ - *b++)
	    return tmp;
	}
	return 0;
}

DxUint32_t DX_VOS_FastMemCpy(DxUint8_t* dst, DxUint8_t* src, DxUint32_t len)
{
	if (dst == DX_NULL || src == DX_NULL || len == 0)
	  return 0;
	  
    return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_MEMCPY_OP_CODE, 3,
								 dst, src, len );
}

void* _DX_VOS_MemMalloc(DxUint aSize)
{
	DxUint32_t *p = DX_NULL;

	if (aSize == 0)
	  return (void*)DX_NULL;
	  
    p = DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_MEMMALLOC_OP_CODE, 1,
								 aSize );
	if (p == 0xA09004 /*error*/)
		return DX_NULL;
	
	return p;
}

void _DX_VOS_MemFree(void* apBuff)
{
	if (apBuff == DX_NULL)
	  return;
	  
    DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_MEMFREE_OP_CODE, 1,
						  apBuff );
}







